;; rysuj-wielokat : wielokat -> true
;; rysuje wielokat reprezentowany przez list dany-wielokat
(define (rysuj-wielokat dany-wielokat)
  (polacz-punkty (cons (ostatni dany-wielokat) dany-wielokat)))

;; polacz-punkty : wielokat -> true
;; rysuje poczenia pomidzy punktami zawartymi na licie dany-wielokat
(define (polacz-punkty dany-wielokat)
  (cond
    [(empty? (rest dany-wielokat)) true]
    [else (and (draw-solid-line (first dany-wielokat) (second dany-wielokat) 'red)
               (polacz-punkty (rest dany-wielokat)))]))

;; ostatni : wielokat -> posn
;; wyciga ostatni struktur posn z listy dany-wielokat
(define (ostatni dany-wielokat)
  (cond
    [(empty? (rest dany-wielokat)) (first dany-wielokat)]
    [else (ostatni (rest dany-wielokat))]))
